/*
 * Decompiled with CFR 0.152.
 */
package jade.lang.acl;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.util.leap.EmptyIterator;
import jade.util.leap.EnumIterator;
import jade.util.leap.Iterator;
import jade.util.leap.Properties;
import jade.util.leap.Serializable;
import java.util.Date;
import java.util.Vector;

public class ACLMessage
implements Serializable {
    private static final long serialVersionUID = 3945353187608998130L;
    public static final int ACCEPT_PROPOSAL = 0;
    public static final int AGREE = 1;
    public static final int CANCEL = 2;
    public static final int CFP = 3;
    public static final int CONFIRM = 4;
    public static final int DISCONFIRM = 5;
    public static final int FAILURE = 6;
    public static final int INFORM = 7;
    public static final int INFORM_IF = 8;
    public static final int INFORM_REF = 9;
    public static final int NOT_UNDERSTOOD = 10;
    public static final int PROPOSE = 11;
    public static final int QUERY_IF = 12;
    public static final int QUERY_REF = 13;
    public static final int REFUSE = 14;
    public static final int REJECT_PROPOSAL = 15;
    public static final int REQUEST = 16;
    public static final int REQUEST_WHEN = 17;
    public static final int REQUEST_WHENEVER = 18;
    public static final int SUBSCRIBE = 19;
    public static final int PROXY = 20;
    public static final int PROPAGATE = 21;
    public static final int UNKNOWN = -1;
    private int performative;
    private static final String[] performatives = new String[22];
    public static final String IGNORE_FAILURE = "JADE-ignore-failure";
    public static final String POST_TIME_STAMP = "JADE-post-ts";
    public static final String TRACE = "JADE-trace";
    private AID source = null;
    private static final int RECEIVERS_EXPECTED_SIZE = 1;
    private static final int REPLYTO_EXPECTED_SIZE = 1;
    private Vector dests = new Vector(1);
    private Vector reply_to = null;
    private StringBuffer content = null;
    private byte[] byteSequenceContent = null;
    private String reply_with = null;
    private String in_reply_to = null;
    private String encoding = null;
    private String language = null;
    private String ontology = null;
    private long reply_byInMillisec = 0L;
    private String protocol = null;
    private String conversation_id = null;
    private Properties userDefProps = null;
    private Envelope messageEnvelope;

    public static String[] getAllPerformativeNames() {
        return performatives;
    }

    public ACLMessage() {
        this.performative = 10;
    }

    public ACLMessage(int perf) {
        this.performative = perf;
    }

    public void setSender(AID s) {
        this.source = s;
    }

    public void addReceiver(AID r) {
        if (r != null) {
            this.dests.addElement(r);
        }
    }

    public boolean removeReceiver(AID r) {
        if (r != null) {
            return this.dests.removeElement(r);
        }
        return false;
    }

    public void clearAllReceiver() {
        this.dests.removeAllElements();
    }

    public void addReplyTo(AID dest) {
        if (dest != null) {
            this.reply_to = this.reply_to == null ? new Vector(1) : this.reply_to;
            this.reply_to.addElement(dest);
        }
    }

    public boolean removeReplyTo(AID dest) {
        if (dest != null && this.reply_to != null) {
            return this.reply_to.removeElement(dest);
        }
        return false;
    }

    public void clearAllReplyTo() {
        if (this.reply_to != null) {
            this.reply_to.removeAllElements();
        }
    }

    public void setPerformative(int perf) {
        this.performative = perf;
    }

    public void setContent(String content) {
        this.byteSequenceContent = null;
        this.content = content != null ? new StringBuffer(content) : null;
    }

    public void setByteSequenceContent(byte[] content) {
        this.content = null;
        this.byteSequenceContent = content;
    }

    public void setReplyWith(String reply) {
        this.reply_with = reply;
    }

    public void setInReplyTo(String reply) {
        this.in_reply_to = reply;
    }

    public void setEncoding(String str) {
        this.encoding = str;
    }

    public void setLanguage(String str) {
        this.language = str;
    }

    public void setOntology(String str) {
        this.ontology = str;
    }

    public void setReplyByDate(Date date) {
        this.reply_byInMillisec = date == null ? 0L : date.getTime();
    }

    public void setProtocol(String str) {
        this.protocol = str;
    }

    public void setConversationId(String str) {
        this.conversation_id = str;
    }

    public Iterator getAllReceiver() {
        return new EnumIterator(this.dests.elements());
    }

    public Iterator getAllReplyTo() {
        if (this.reply_to == null) {
            return EmptyIterator.getInstance();
        }
        return new EnumIterator(this.reply_to.elements());
    }

    public AID getSender() {
        return this.source;
    }

    public static String getPerformative(int perf) {
        try {
            return performatives[perf];
        }
        catch (Exception e) {
            return performatives[10];
        }
    }

    public static int getInteger(String perf) {
        String tmp = perf.toUpperCase();
        int i = 0;
        while (i < performatives.length) {
            if (performatives[i].equals(tmp)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getPerformative() {
        return this.performative;
    }

    public boolean hasByteSequenceContent() {
        return this.byteSequenceContent != null;
    }

    public String getContent() {
        if (this.content != null) {
            return new String(this.content);
        }
        if (this.byteSequenceContent != null) {
            return new String(this.byteSequenceContent);
        }
        return null;
    }

    public byte[] getByteSequenceContent() {
        if (this.content != null) {
            return this.content.toString().getBytes();
        }
        if (this.byteSequenceContent != null) {
            return this.byteSequenceContent;
        }
        return null;
    }

    public String getReplyWith() {
        return this.reply_with;
    }

    public String getInReplyTo() {
        return this.in_reply_to;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getOntology() {
        return this.ontology;
    }

    public Date getReplyByDate() {
        if (this.reply_byInMillisec != 0L) {
            return new Date(this.reply_byInMillisec);
        }
        return null;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getConversationId() {
        return this.conversation_id;
    }

    public void addUserDefinedParameter(String key, String value) {
        this.userDefProps = this.userDefProps == null ? new Properties() : this.userDefProps;
        this.userDefProps.setProperty(key, value);
    }

    public String getUserDefinedParameter(String key) {
        if (this.userDefProps == null) {
            return null;
        }
        return this.userDefProps.getProperty(key);
    }

    public Properties getAllUserDefinedParameters() {
        this.userDefProps = this.userDefProps == null ? new Properties() : this.userDefProps;
        return this.userDefProps;
    }

    public boolean removeUserDefinedParameter(String key) {
        if (this.userDefProps == null) {
            return false;
        }
        return this.userDefProps.remove(key) != null;
    }

    public void setEnvelope(Envelope e) {
        this.messageEnvelope = e;
    }

    public void setDefaultEnvelope() {
        this.messageEnvelope = new Envelope();
        this.messageEnvelope.setFrom(this.source);
        EnumIterator it = new EnumIterator(this.dests.elements());
        while (it.hasNext()) {
            this.messageEnvelope.addTo((AID)it.next());
        }
        this.messageEnvelope.setDate(new Date());
    }

    public Envelope getEnvelope() {
        return this.messageEnvelope;
    }

    public synchronized Object clone() {
        ACLMessage result = new ACLMessage(10);
        result.performative = this.performative;
        result.source = this.source;
        result.content = this.content;
        result.byteSequenceContent = this.byteSequenceContent;
        result.reply_with = this.reply_with;
        result.in_reply_to = this.in_reply_to;
        result.encoding = this.encoding;
        result.language = this.language;
        result.ontology = this.ontology;
        result.reply_byInMillisec = this.reply_byInMillisec;
        result.protocol = this.protocol;
        result.conversation_id = this.conversation_id;
        result.userDefProps = this.userDefProps;
        if (this.messageEnvelope != null) {
            result.messageEnvelope = (Envelope)this.messageEnvelope.clone();
        }
        result.dests = new Vector(this.dests.size());
        int i = 0;
        while (i < this.dests.size()) {
            result.dests.addElement(this.dests.elementAt(i));
            ++i;
        }
        if (this.reply_to != null) {
            result.reply_to = new Vector(this.reply_to.size());
            int i2 = 0;
            while (i2 < this.reply_to.size()) {
                result.reply_to.addElement(this.reply_to.elementAt(i2));
                ++i2;
            }
        }
        return result;
    }

    public void reset() {
        this.source = null;
        this.dests.removeAllElements();
        if (this.reply_to != null) {
            this.reply_to.removeAllElements();
        }
        this.performative = 10;
        this.content = null;
        this.byteSequenceContent = null;
        this.reply_with = null;
        this.in_reply_to = null;
        this.encoding = null;
        this.language = null;
        this.ontology = null;
        this.reply_byInMillisec = 0L;
        this.protocol = null;
        this.conversation_id = null;
        if (this.userDefProps != null) {
            this.userDefProps.clear();
        }
    }

    public ACLMessage createReply() {
        ACLMessage m = (ACLMessage)this.clone();
        m.clearAllReceiver();
        Iterator it = this.getAllReplyTo();
        while (it.hasNext()) {
            m.addReceiver((AID)it.next());
        }
        if (this.reply_to == null || this.reply_to.isEmpty()) {
            m.addReceiver(this.getSender());
        }
        m.clearAllReplyTo();
        m.setLanguage(this.getLanguage());
        m.setOntology(this.getOntology());
        m.setProtocol(this.getProtocol());
        m.setSender(null);
        m.setInReplyTo(this.getReplyWith());
        if (this.source != null) {
            m.setReplyWith(this.source.getName() + System.currentTimeMillis());
        } else {
            m.setReplyWith("X" + System.currentTimeMillis());
        }
        m.setConversationId(this.getConversationId());
        m.setReplyByDate(null);
        m.setContent(null);
        m.setEncoding(null);
        if (this.messageEnvelope != null) {
            m.setDefaultEnvelope();
            String aclCodec = this.messageEnvelope.getAclRepresentation();
            if (aclCodec != null) {
                m.getEnvelope().setAclRepresentation(aclCodec);
            }
        } else {
            m.setEnvelope(null);
        }
        return m;
    }

    public Iterator getAllIntendedReceiver() {
        Iterator it = null;
        Envelope env = this.getEnvelope();
        if (env != null && !(it = env.getAllIntendedReceiver()).hasNext()) {
            it = env.getAllTo();
        }
        if (it == null || !it.hasNext()) {
            it = this.getAllReceiver();
        }
        return it;
    }

    static {
        ACLMessage.performatives[0] = "ACCEPT-PROPOSAL";
        ACLMessage.performatives[1] = "AGREE";
        ACLMessage.performatives[2] = "CANCEL";
        ACLMessage.performatives[3] = "CFP";
        ACLMessage.performatives[4] = "CONFIRM";
        ACLMessage.performatives[5] = "DISCONFIRM";
        ACLMessage.performatives[6] = "FAILURE";
        ACLMessage.performatives[7] = "INFORM";
        ACLMessage.performatives[8] = "INFORM-IF";
        ACLMessage.performatives[9] = "INFORM-REF";
        ACLMessage.performatives[10] = "NOT-UNDERSTOOD";
        ACLMessage.performatives[11] = "PROPOSE";
        ACLMessage.performatives[12] = "QUERY-IF";
        ACLMessage.performatives[13] = "QUERY-REF";
        ACLMessage.performatives[14] = "REFUSE";
        ACLMessage.performatives[15] = "REJECT-PROPOSAL";
        ACLMessage.performatives[16] = "REQUEST";
        ACLMessage.performatives[17] = "REQUEST-WHEN";
        ACLMessage.performatives[18] = "REQUEST-WHENEVER";
        ACLMessage.performatives[19] = "SUBSCRIBE";
        ACLMessage.performatives[20] = "PROXY";
        ACLMessage.performatives[21] = "PROPAGATE";
    }
}

